document.addEventListener("DOMContentLoaded", () => {
    const workerDropdown = document.getElementById("worker-dropdown");
    const tableBody = document.getElementById("work-hours-table");

    const fetchWorkers = async () => {
        try {
            const response = await fetch("../php/owner-work-hours.php?action=fetch-workers");
            const result = await response.json();

            if (result.data) {
                populateWorkerDropdown(result.data);
            } else {
                alert(`Error fetching workers: ${result.error}`);
            }
        } catch (error) {
            console.error("Error fetching workers:", error);
            alert("Failed to fetch workers. Please try again.");
        }
    };

    const populateWorkerDropdown = (workers) => {
        workers.forEach((worker) => {
            const option = document.createElement("option");
            option.value = worker.id;
            option.textContent = `${worker.first_name} ${worker.last_name}`;
            workerDropdown.appendChild(option);
        });

        workerDropdown.addEventListener("change", () => {
            const workerId = workerDropdown.value;
            if (workerId) {
                fetchWorkHours(workerId);
            } else {
                tableBody.innerHTML = "<tr><td colspan='4'>Select a worker to view their hours</td></tr>";
            }
        });
    };

    const fetchWorkHours = async (workerId) => {
        try {
            const response = await fetch(`../php/owner-work-hours.php?action=fetch-work-hours&worker_id=${workerId}`);
            const result = await response.json();

            if (result.data) {
                renderWorkHoursTable(result.data);
            } else {
                alert(`Error fetching work hours: ${result.error}`);
            }
        } catch (error) {
            console.error("Error fetching work hours:", error);
            alert("Failed to fetch work hours. Please try again.");
        }
    };

    const renderWorkHoursTable = (data) => {
        tableBody.innerHTML = "";

        if (data.length === 0) {
            tableBody.innerHTML = "<tr><td colspan='4'>No work hours recorded</td></tr>";
            return;
        }

        data.forEach((row) => {
            const tr = document.createElement("tr");
            tr.innerHTML = `
                <td>${row.date}</td>
                <td>${row.clock_in_time}</td>
                <td>${row.clock_out_time}</td>
                <td>${row.total_work_hours}</td>
            `;
            tableBody.appendChild(tr);
        });
    };

    fetchWorkers();
});
